/*
 * Decompiled with CFR 0.152.
 */
package ec.gob.sri.dimm.ats.ui.asistentes.paginas.recaps;

import ec.gob.sri.dimm.api.modelo.ModeloValores;
import ec.gob.sri.dimm.api.modelo.ObjetoModelo;
import ec.gob.sri.dimm.api.modelo.validacion.InformacionValidable;
import ec.gob.sri.dimm.api.modelo.validacion.ListenerValidacionModeloPaginaAsistente;
import ec.gob.sri.dimm.api.ui.VistaModelo;
import ec.gob.sri.dimm.api.ui.asistentes.PaginaAsistente;
import ec.gob.sri.dimm.ats.modelo.obj.Periodo;
import ec.gob.sri.dimm.ats.modelo.obj.asistente.valores.ModeloValoresCompVenta;
import ec.gob.sri.dimm.ats.modelo.obj.recap.Consumo;
import ec.gob.sri.dimm.ats.modelo.obj.recap.Recap;
import ec.gob.sri.dimm.ats.modelo.obj.ventas.Compensacion;
import ec.gob.sri.dimm.ats.ui.componente.CompensacionComposite;
import ec.gob.sri.dimm.ats.ui.componente.OperacionCompositeCompensaciones;
import java.beans.PropertyChangeListener;
import java.math.BigDecimal;
import org.eclipse.core.databinding.DataBindingContext;
import org.eclipse.core.databinding.beans.BeanProperties;
import org.eclipse.core.databinding.beans.BeansObservables;
import org.eclipse.core.databinding.beans.PojoObservables;
import org.eclipse.core.databinding.observable.value.IObservableValue;
import org.eclipse.jface.databinding.swt.ISWTObservableValue;
import org.eclipse.jface.databinding.swt.SWTObservables;
import org.eclipse.jface.databinding.swt.WidgetProperties;
import org.eclipse.swt.events.FocusAdapter;
import org.eclipse.swt.events.FocusEvent;
import org.eclipse.swt.events.FocusListener;
import org.eclipse.swt.events.KeyAdapter;
import org.eclipse.swt.events.KeyEvent;
import org.eclipse.swt.events.KeyListener;
import org.eclipse.swt.graphics.Font;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Text;
import org.eclipse.swt.widgets.Widget;
import org.eclipse.wb.swt.SWTResourceManager;

public class DatosConsumo
extends PaginaAsistente
implements VistaModelo<Consumo> {
    private DataBindingContext m_bindingContext;
    private boolean editando;
    private Consumo modeloDatos;
    private ModeloValoresCompVenta modeloValores;
    private Text txtNumVouchers;
    private Text txtConsumoCero;
    private Text txtConsumoNoCero;
    private Text txtTotalConsumo;
    private Text txtIvaBienes;
    private Text txtIvaServicios;
    private Text textRetencionIvaCien;
    private Text txtComision;
    private Text txtMontoIva;
    private Text txtRetencion10;
    private Text txtRetencion20;
    private final Periodo periodo;
    private Label lblRetencion10;
    private Label lblRetencion20;
    private Label lblRetencinIva_50;
    private Text txtRetencionIva50;
    private Composite container;
    private CompensacionComposite compositeCompensaciones;

    public DatosConsumo(boolean editando, Periodo periodo) {
        super("DatosConsumo", "Anexo Transaccional", "Especifique la informaci\u00f3n correspondiente al consumo");
        this.editando = editando;
        this.periodo = periodo;
    }

    public void setModeloDatos(Consumo modeloDatos) {
        this.modeloDatos = modeloDatos;
    }

    public void inicializarModeloValores() {
        this.modeloValores = new ModeloValoresCompVenta(this.periodo);
        this.modeloValores.inicializar();
        this.modeloValores.cargarTiposDeComprobantes(((Recap)this.modeloDatos.getPropietario()).getEstablecimiento().getTipoIdentificacion());
    }

    public void procesarModeloDatos() {
        this.modeloDatos.addPropertyChangeListener((PropertyChangeListener)new ListenerValidacionModeloPaginaAsistente((InformacionValidable)this.modeloDatos, (PaginaAsistente)this));
    }

    public void createControl(Composite parent) {
        this.container = new Composite(parent, 0);
        this.setControl((Control)this.container);
        this.container.setLayout((Layout)new GridLayout(4, false));
        Label lblInformacinComprobantes = new Label(this.container, 0);
        lblInformacinComprobantes.setText("Informaci\u00f3n Consumo");
        lblInformacinComprobantes.setFont(SWTResourceManager.getBoldFont((Font)lblInformacinComprobantes.getFont()));
        new Label(this.container, 0);
        new Label(this.container, 0);
        new Label(this.container, 0);
        Label lblNDeVouchers = new Label(this.container, 0);
        GridData gd_lblNDeVouchers = new GridData(16384, 0x1000000, false, false, 1, 1);
        gd_lblNDeVouchers.widthHint = 100;
        lblNDeVouchers.setLayoutData((Object)gd_lblNDeVouchers);
        lblNDeVouchers.setText("N\u00b0 de Vouchers");
        this.txtNumVouchers = new Text(this.container, 2048);
        this.txtNumVouchers.addFocusListener((FocusListener)new FocusAdapter(){

            public void focusGained(FocusEvent e) {
                DatosConsumo.this.txtNumVouchers.selectAll();
            }
        });
        this.txtNumVouchers.setTextLimit(9);
        GridData gd_txtNumVouchers = new GridData(16384, 0x1000000, true, false, 1, 1);
        gd_txtNumVouchers.widthHint = 100;
        this.txtNumVouchers.setLayoutData((Object)gd_txtNumVouchers);
        new Label(this.container, 0);
        new Label(this.container, 0);
        Label lblConsumo = new Label(this.container, 0);
        lblConsumo.setText("Consumo 0%");
        this.txtConsumoCero = new Text(this.container, 2048);
        this.txtConsumoCero.addFocusListener((FocusListener)new FocusAdapter(){

            public void focusGained(FocusEvent e) {
                DatosConsumo.this.txtConsumoCero.selectAll();
            }
        });
        this.txtConsumoCero.setTextLimit(15);
        GridData gd_txtConsumoCero = new GridData(16384, 0x1000000, true, false, 1, 1);
        gd_txtConsumoCero.widthHint = 100;
        this.txtConsumoCero.setLayoutData((Object)gd_txtConsumoCero);
        Label lblComisin = new Label(this.container, 0);
        GridData gd_lblComisin = new GridData(131072, 0x1000000, false, false, 1, 1);
        gd_lblComisin.widthHint = 80;
        lblComisin.setLayoutData((Object)gd_lblComisin);
        lblComisin.setText("Comisi\u00f3n");
        this.txtComision = new Text(this.container, 2048);
        this.txtComision.addFocusListener((FocusListener)new FocusAdapter(){

            public void focusGained(FocusEvent e) {
                DatosConsumo.this.txtComision.selectAll();
            }
        });
        this.txtComision.setTextLimit(15);
        GridData gd_txtComision = new GridData(16384, 0x1000000, true, false, 1, 1);
        gd_txtComision.widthHint = 100;
        this.txtComision.setLayoutData((Object)gd_txtComision);
        Label lblConsumoGravadoDiferente = new Label(this.container, 0);
        lblConsumoGravadoDiferente.setLayoutData((Object)new GridData(131072, 0x1000000, false, false, 1, 1));
        lblConsumoGravadoDiferente.setText("Consumo Gravado diferente de 0%");
        this.txtConsumoNoCero = new Text(this.container, 2048);
        this.txtConsumoNoCero.addFocusListener((FocusListener)new FocusAdapter(){

            public void focusGained(FocusEvent e) {
                DatosConsumo.this.txtConsumoNoCero.selectAll();
            }
        });
        this.txtConsumoNoCero.setTextLimit(15);
        GridData gd_txtConsumoNoCero = new GridData(16384, 0x1000000, true, false, 1, 1);
        gd_txtConsumoNoCero.widthHint = 100;
        this.txtConsumoNoCero.setLayoutData((Object)gd_txtConsumoNoCero);
        Label lblMontoIva = new Label(this.container, 0);
        lblMontoIva.setText("Monto IVA");
        this.txtMontoIva = new Text(this.container, 2048);
        this.txtMontoIva.addFocusListener((FocusListener)new FocusAdapter(){

            public void focusGained(FocusEvent e) {
                DatosConsumo.this.txtMontoIva.selectAll();
            }
        });
        this.txtMontoIva.addKeyListener((KeyListener)new KeyAdapter(){

            public void keyPressed(KeyEvent e) {
                DatosConsumo.this.modeloDatos.setModificaIva(true);
            }
        });
        this.txtMontoIva.setTextLimit(15);
        GridData gd_txtMontoIva = new GridData(16384, 0x1000000, true, false, 1, 1);
        gd_txtMontoIva.widthHint = 100;
        this.txtMontoIva.setLayoutData((Object)gd_txtMontoIva);
        this.crearCompositeCompensaciones();
        new Label(this.container, 0);
        Label lblTotalConsumo = new Label(this.container, 0);
        lblTotalConsumo.setText("Total Consumo");
        this.txtTotalConsumo = new Text(this.container, 2048);
        this.txtTotalConsumo.addFocusListener((FocusListener)new FocusAdapter(){

            public void focusGained(FocusEvent e) {
                DatosConsumo.this.txtTotalConsumo.selectAll();
            }
        });
        this.txtTotalConsumo.setTextLimit(15);
        GridData gd_txtTotalConsumo = new GridData(16384, 0x1000000, true, false, 1, 1);
        gd_txtTotalConsumo.widthHint = 100;
        this.txtTotalConsumo.setLayoutData((Object)gd_txtTotalConsumo);
        new Label(this.container, 0);
        new Label(this.container, 0);
        Label label = new Label(this.container, 0);
        GridData gd_label = new GridData(16384, 0x1000000, false, false, 1, 1);
        gd_label.verticalIndent = 12;
        label.setLayoutData((Object)gd_label);
        label.setText("Valores Retenidos");
        label.setFont(SWTResourceManager.getBoldFont((Font)label.getFont()));
        new Label(this.container, 0);
        new Label(this.container, 0);
        new Label(this.container, 0);
        this.lblRetencion10 = new Label(this.container, 0);
        this.lblRetencion10.setText("Retenci\u00f3n IVA 10%");
        this.txtRetencion10 = new Text(this.container, 2048);
        GridData gd_txtRetencion10 = new GridData(16384, 0x1000000, true, false, 1, 1);
        gd_txtRetencion10.widthHint = 100;
        this.txtRetencion10.setLayoutData((Object)gd_txtRetencion10);
        new Label(this.container, 0);
        new Label(this.container, 0);
        this.lblRetencion20 = new Label(this.container, 0);
        this.lblRetencion20.setText("Retenci\u00f3n IVA 20%");
        this.txtRetencion20 = new Text(this.container, 2048);
        GridData gd_txtRetencion20 = new GridData(16384, 0x1000000, true, false, 1, 1);
        gd_txtRetencion20.widthHint = 100;
        this.txtRetencion20.setLayoutData((Object)gd_txtRetencion20);
        new Label(this.container, 0);
        new Label(this.container, 0);
        Label lblRetencinIvaBienes = new Label(this.container, 0);
        lblRetencinIvaBienes.setText("Retenci\u00f3n IVA 30 %");
        this.txtIvaBienes = new Text(this.container, 2048);
        this.txtIvaBienes.addFocusListener((FocusListener)new FocusAdapter(){

            public void focusGained(FocusEvent e) {
                DatosConsumo.this.txtIvaBienes.selectAll();
            }
        });
        this.txtIvaBienes.setTextLimit(15);
        GridData gd_txtIvaBienes = new GridData(16384, 128, true, false, 1, 1);
        gd_txtIvaBienes.widthHint = 100;
        this.txtIvaBienes.setLayoutData((Object)gd_txtIvaBienes);
        new Label(this.container, 0);
        new Label(this.container, 0);
        this.lblRetencinIva_50 = new Label(this.container, 0);
        this.lblRetencinIva_50.setText("Retenci\u00f3n IVA 50%");
        this.txtRetencionIva50 = new Text(this.container, 2048);
        this.txtRetencionIva50.setTextLimit(15);
        GridData gd_txtRetencionIva50 = new GridData(16384, 0x1000000, true, false, 1, 1);
        gd_txtRetencionIva50.widthHint = 100;
        this.txtRetencionIva50.setLayoutData((Object)gd_txtRetencionIva50);
        new Label(this.container, 0);
        new Label(this.container, 0);
        Label lblRetencinIvaServicios = new Label(this.container, 0);
        lblRetencinIvaServicios.setText("Retenci\u00f3n IVA 70 %");
        this.txtIvaServicios = new Text(this.container, 2048);
        this.txtIvaServicios.addFocusListener((FocusListener)new FocusAdapter(){

            public void focusGained(FocusEvent e) {
                DatosConsumo.this.txtIvaServicios.selectAll();
            }
        });
        this.txtIvaServicios.setTextLimit(15);
        GridData gd_txtIvaServicios = new GridData(16384, 0x1000000, true, false, 1, 1);
        gd_txtIvaServicios.widthHint = 100;
        this.txtIvaServicios.setLayoutData((Object)gd_txtIvaServicios);
        new Label(this.container, 0);
        new Label(this.container, 0);
        Label lblRetencinIva = new Label(this.container, 0);
        lblRetencinIva.setText("Retenci\u00f3n IVA 100%");
        this.textRetencionIvaCien = new Text(this.container, 2048);
        this.textRetencionIvaCien.addFocusListener((FocusListener)new FocusAdapter(){

            public void focusGained(FocusEvent e) {
                DatosConsumo.this.textRetencionIvaCien.selectAll();
            }
        });
        this.textRetencionIvaCien.setTextLimit(15);
        GridData gd_textRetencionIvaCien = new GridData(16384, 0x1000000, true, false, 1, 1);
        gd_textRetencionIvaCien.widthHint = 100;
        this.textRetencionIvaCien.setLayoutData((Object)gd_textRetencionIvaCien);
        new Label(this.container, 0);
        new Label(this.container, 0);
        this.m_bindingContext = this.initDataBindings();
        this.procesarModeloDatos();
    }

    private void crearCompositeCompensaciones() {
        this.compositeCompensaciones = new CompensacionComposite(this.container, 0, (ModeloValores)this.modeloValores, (ObjetoModelo)this.modeloDatos, this);
        this.compositeCompensaciones.setLayoutData(new GridData(16384, 0x1000000, false, false, 3, 1));
        this.compositeCompensaciones.setFuncionSeleccionar(new OperacionCompositeCompensaciones(){

            @Override
            public void operar(Compensacion compensacion) {
                if (!DatosConsumo.this.modeloDatos.getCompensaciones().contains(compensacion)) {
                    BigDecimal porcentajeCompensacion = DatosConsumo.this.modeloValores.obtenerPorcentajeCompensacion(compensacion.getCodigo());
                    compensacion.setPorcentajeCompensacion(porcentajeCompensacion);
                    compensacion.setMonto("0.00");
                    DatosConsumo.this.modeloDatos.agregarCompensacion(compensacion);
                }
            }
        });
        this.compositeCompensaciones.setFuncionEliminar(new OperacionCompositeCompensaciones(){

            @Override
            public void operar(Compensacion compensacion) {
                DatosConsumo.this.modeloDatos.eliminarCompensaciones(compensacion);
            }
        });
    }

    protected DataBindingContext initDataBindings() {
        DataBindingContext bindingContext = new DataBindingContext();
        ISWTObservableValue observeTextTxtNumVouchersObserveWidget = WidgetProperties.text((int)24).observe((Widget)this.txtNumVouchers);
        IObservableValue numVouchersModeloDatosObserveValue = BeanProperties.value((String)"numVouchers").observe((Object)this.modeloDatos);
        bindingContext.bindValue((IObservableValue)observeTextTxtNumVouchersObserveWidget, numVouchersModeloDatosObserveValue, null, null);
        ISWTObservableValue observeTextTxtConsumoCeroObserveWidget = WidgetProperties.text((int)24).observe((Widget)this.txtConsumoCero);
        IObservableValue consumoCeroModeloDatosObserveValue = BeanProperties.value((String)"consumoCero").observe((Object)this.modeloDatos);
        bindingContext.bindValue((IObservableValue)observeTextTxtConsumoCeroObserveWidget, consumoCeroModeloDatosObserveValue, null, null);
        ISWTObservableValue observeTextTxtComisionObserveWidget = WidgetProperties.text((int)24).observe((Widget)this.txtComision);
        IObservableValue comisionModeloDatosObserveValue = BeanProperties.value((String)"comision").observe((Object)this.modeloDatos);
        bindingContext.bindValue((IObservableValue)observeTextTxtComisionObserveWidget, comisionModeloDatosObserveValue, null, null);
        ISWTObservableValue observeTextTxtConsumoNoCeroObserveWidget = WidgetProperties.text((int)24).observe((Widget)this.txtConsumoNoCero);
        IObservableValue consumoGravadoModeloDatosObserveValue = BeanProperties.value((String)"consumoGravado").observe((Object)this.modeloDatos);
        bindingContext.bindValue((IObservableValue)observeTextTxtConsumoNoCeroObserveWidget, consumoGravadoModeloDatosObserveValue, null, null);
        ISWTObservableValue observeTextTxtMontoIvaObserveWidget = WidgetProperties.text((int)24).observe((Widget)this.txtMontoIva);
        IObservableValue montoIvaModeloDatosObserveValue = BeanProperties.value((String)"montoIva").observe((Object)this.modeloDatos);
        bindingContext.bindValue((IObservableValue)observeTextTxtMontoIvaObserveWidget, montoIvaModeloDatosObserveValue, null, null);
        ISWTObservableValue observeTextTxtTotalConsumoObserveWidget = WidgetProperties.text((int)24).observe((Widget)this.txtTotalConsumo);
        IObservableValue totalConsumoModeloDatosObserveValue = BeanProperties.value((String)"totalConsumo").observe((Object)this.modeloDatos);
        bindingContext.bindValue((IObservableValue)observeTextTxtTotalConsumoObserveWidget, totalConsumoModeloDatosObserveValue, null, null);
        ISWTObservableValue txtIvaBienesObserveTextObserveWidget = SWTObservables.observeText((Control)this.txtIvaBienes, (int)24);
        IObservableValue modeloDatosRetencionIvaBienesObserveValue = BeansObservables.observeValue((Object)this.modeloDatos, (String)"retencionIvaBienes");
        bindingContext.bindValue((IObservableValue)txtIvaBienesObserveTextObserveWidget, modeloDatosRetencionIvaBienesObserveValue, null, null);
        ISWTObservableValue txtIvaServiciosObserveTextObserveWidget = SWTObservables.observeText((Control)this.txtIvaServicios, (int)24);
        IObservableValue modeloDatosRetencionIvaServiciosObserveValue = BeansObservables.observeValue((Object)this.modeloDatos, (String)"retencionIvaServicios");
        bindingContext.bindValue((IObservableValue)txtIvaServiciosObserveTextObserveWidget, modeloDatosRetencionIvaServiciosObserveValue, null, null);
        ISWTObservableValue textRetencionIvaCienObserveTextObserveWidget = SWTObservables.observeText((Control)this.textRetencionIvaCien, (int)24);
        IObservableValue modeloDatosRetencionIvaCienObserveValue = BeansObservables.observeValue((Object)this.modeloDatos, (String)"retencionIvaCien");
        bindingContext.bindValue((IObservableValue)textRetencionIvaCienObserveTextObserveWidget, modeloDatosRetencionIvaCienObserveValue, null, null);
        ISWTObservableValue txtRetencion10ObserveTextObserveWidget = SWTObservables.observeText((Control)this.txtRetencion10, (int)24);
        IObservableValue modeloDatosRetencionIvaDiezObserveValue = BeansObservables.observeValue((Object)this.modeloDatos, (String)"retencionIvaDiez");
        bindingContext.bindValue((IObservableValue)txtRetencion10ObserveTextObserveWidget, modeloDatosRetencionIvaDiezObserveValue, null, null);
        ISWTObservableValue txtRetencion20ObserveTextObserveWidget = SWTObservables.observeText((Control)this.txtRetencion20, (int)24);
        IObservableValue modeloDatosRetencionIvaVeinteObserveValue = BeansObservables.observeValue((Object)this.modeloDatos, (String)"retencionIvaVeinte");
        bindingContext.bindValue((IObservableValue)txtRetencion20ObserveTextObserveWidget, modeloDatosRetencionIvaVeinteObserveValue, null, null);
        ISWTObservableValue lblRetencion10ObserveEnabledObserveWidget_1 = SWTObservables.observeEnabled((Control)this.lblRetencion10);
        IObservableValue periodoPeriodoDeAnexoDesdeJunio2015ObserveValue = PojoObservables.observeValue((Object)this.periodo, (String)"periodoDeAnexoDesdeJunio2015");
        bindingContext.bindValue((IObservableValue)lblRetencion10ObserveEnabledObserveWidget_1, periodoPeriodoDeAnexoDesdeJunio2015ObserveValue, null, null);
        ISWTObservableValue txtRetencion10ObserveEnabledObserveWidget_1 = SWTObservables.observeEnabled((Control)this.txtRetencion10);
        bindingContext.bindValue((IObservableValue)txtRetencion10ObserveEnabledObserveWidget_1, periodoPeriodoDeAnexoDesdeJunio2015ObserveValue, null, null);
        ISWTObservableValue lblRetencion20ObserveEnabledObserveWidget_1 = SWTObservables.observeEnabled((Control)this.lblRetencion20);
        bindingContext.bindValue((IObservableValue)lblRetencion20ObserveEnabledObserveWidget_1, periodoPeriodoDeAnexoDesdeJunio2015ObserveValue, null, null);
        ISWTObservableValue txtRetencion20ObserveEnabledObserveWidget_1 = SWTObservables.observeEnabled((Control)this.txtRetencion20);
        bindingContext.bindValue((IObservableValue)txtRetencion20ObserveEnabledObserveWidget_1, periodoPeriodoDeAnexoDesdeJunio2015ObserveValue, null, null);
        ISWTObservableValue txtRetencionIva50ObserveTextObserveWidget = SWTObservables.observeText((Control)this.txtRetencionIva50, (int)24);
        IObservableValue modeloDatosRetencionIvaServicios50ObserveValue = BeansObservables.observeValue((Object)this.modeloDatos, (String)"retencionIvaServicios50");
        bindingContext.bindValue((IObservableValue)txtRetencionIva50ObserveTextObserveWidget, modeloDatosRetencionIvaServicios50ObserveValue, null, null);
        ISWTObservableValue lblRetencinIva_50ObserveEnabledObserveWidget = SWTObservables.observeEnabled((Control)this.lblRetencinIva_50);
        IObservableValue periodoAnexoEnPeriodoDesdeEnero2016ObserveValue = PojoObservables.observeValue((Object)this.periodo, (String)"anexoEnPeriodoDesdeEnero2016");
        bindingContext.bindValue((IObservableValue)lblRetencinIva_50ObserveEnabledObserveWidget, periodoAnexoEnPeriodoDesdeEnero2016ObserveValue, null, null);
        ISWTObservableValue txtRetencionIva50ObserveEnabledObserveWidget = SWTObservables.observeEnabled((Control)this.txtRetencionIva50);
        bindingContext.bindValue((IObservableValue)txtRetencionIva50ObserveEnabledObserveWidget, periodoAnexoEnPeriodoDesdeEnero2016ObserveValue, null, null);
        ISWTObservableValue compositeCompensacionesObserveVisibleObserveWidget = SWTObservables.observeVisible((Control)this.compositeCompensaciones);
        IObservableValue periodoAnexoEnPeriodoDesdeMayo2016ObserveValue = PojoObservables.observeValue((Object)this.periodo, (String)"anexoEnPeriodoDesdeMayo2016");
        bindingContext.bindValue((IObservableValue)compositeCompensacionesObserveVisibleObserveWidget, periodoAnexoEnPeriodoDesdeMayo2016ObserveValue, null, null);
        return bindingContext;
    }
}

